
import gurobipy as gp

# Create a new model
m = gp.Model("Nova Transport")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="business_class") # number of business class tickets
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="coach_class") # number of coach class tickets


# Set objective function
m.setObjective(300*x1 + 150*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 600, "Total Passengers")
m.addConstr(x2 <= 4*x1, "Coach Preference")
m.addConstr(x1 >= 45, "Min Business Class")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Business Class Tickets: {x1.x}")
    print(f"Number of Coach Class Tickets: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

