
from gurobipy import *

# Create a new model
m = Model("Nova Transport Profit Maximization")

# Define variables
x1 = m.addVar(lb=45, name="business_class_tickets")  # At least 45 business class tickets
x2 = m.addVar(name="coach_class_tickets")

# Objective function: Maximize profit
m.setObjective(300*x1 + 150*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 600, name="total_passengers")
m.addConstr(x2 >= 4*x1 + 1, name="coach_vs_business_ratio")

# Solve the model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Maximum Profit: ${m.objVal:.0f}")
    print(f"Business Class Tickets Sold: {x1.x:.0f}")
    print(f"Coach Class Tickets Sold: {x2.x:.0f}")
else:
    print("No optimal solution found")
