
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=45, name="business_class", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, name="coach_class", vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 300*x1 + 150*x2
    model.setObjective(300*x1 + 150*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 600, name="total_passengers")
    model.addConstr(x2 >= 4*x1, name="coach_vs_business")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found: business_class = {x1.varValue}, coach_class = {x2.varValue}")
        print(f"Maximum profit: ${300*x1.varValue + 150*x2.varValue:.2f}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
