
import gurobipy as gp

# Create a new model
m = gp.Model("crop_optimization")

# Create variables
x1 = m.addVar(lb=0, name="acres_corn")  # Acres of corn
x2 = m.addVar(lb=0, name="acres_peas")  # Acres of peas


# Set objective function
m.setObjective(200*x1 + 250*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 40, "land_constraint")
m.addConstr(50*x1 + 60*x2 <= 4350, "fertilizer_cost_constraint")
m.addConstr(60*x1 + 90*x2 <= 6000, "fertilizer_time_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Corn: {x1.x}")
    print(f"Acres of Peas: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

