
import gurobipy as gp

# Create a new model
m = gp.Model("Agricultural_Planning")

# Define the variables
x1 = m.addVar(name="corn_acres", lb=0)
x2 = m.addVar(name="peas_acres", lb=0)

# Objective function: Maximize profit
m.setObjective(200*x1 + 250*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 40, name="land_constraint")
m.addConstr(50*x1 + 60*x2 <= 4350, name="fertilizer_constraint")
m.addConstr(60*x1 + 90*x2 <= 6000, name="time_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Acres of corn: {x1.varValue}")
    print(f"Acres of peas: {x2.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found.")
