
from gurobipy import *

# Create a new model
model = Model("FastFoodRestaurant")

# Define the variables
x1 = model.addVar(vtype=GRB.INTEGER, name="waiters")
x2 = model.addVar(vtype=GRB.INTEGER, name="managers")

# Set the objective function to minimize
model.setObjective(1200*x1 + 2000*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(x1 + x2 >= 50, "total_workers")
model.addConstr(x2 >= 15, "min_managers")
model.addConstr(x2 >= (1/3)*x1, "manager_waiter_ratio")
model.addConstr(1200*x1 + 2000*x2 <= 500000, "wage_bill")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: {model.objVal} with {x1.varName} = {x1.x} and {x2.varName} = {x2.x}")
else:
    print("No optimal solution found")
