
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="waiters", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, name="managers", vtype=gurobi.GRB.INTEGER)

    # Objective function: minimize 1200*x1 + 2000*x2
    model.setObjective(1200*x1 + 2000*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + x2 >= 50, name="min_workers")
    model.addConstr(x2 >= 15, name="min_managers")
    model.addConstr(x2 >= (1/3)*x1, name="manager_to_waiter_ratio")
    model.addConstr(1200*x1 + 2000*x2 <= 500000, name="wage_bill")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of waiters: {x1.varValue}")
        print(f"Number of managers: {x2.varValue}")
        print(f"Weekly wage bill: {1200*x1.varValue + 2000*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
