
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("TomMusic_Optimization")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="Piano_A") # units of Piano A
x2 = m.addVar(vtype=GRB.INTEGER, name="Piano_B") # units of Piano B


# Set objective function: Minimize total cost
m.setObjective(12*x1 + 4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 450, "Budget_Constraint") # Budget constraint
m.addConstr(25*x1 + 10*x2 >= 250, "Customer_Constraint") # Customer constraint
m.addConstr(x1 >= 0, "NonNegativity_x1") # Non-negativity constraint for x1
m.addConstr(x2 >= 0, "NonNegativity_x2") # Non-negativity constraint for x2


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Piano A units: {x1.x}")
    print(f"Number of Piano B units: {x2.x}")
    print(f"Minimum Cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

