
from gurobipy import *

# Create a new model
m = Model("TomMusic_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Piano_A_Units")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Piano_B_Units")

# Set objective function
m.setObjective(32*x1 + 19*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(25*x1 + 10*x2 >= 250, "Attract_at_least_250_customers")
m.addConstr(20*x1 + 15*x2 <= 450, "Daily_budget_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Piano A units: {x1.x}")
    print(f"Piano B units: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
