
import gurobi

def solve_piano_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Units of Piano A
    x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Units of Piano B

    # Objective function: Minimize 12x1 + 4x2
    model.setObjective(12 * x1 + 4 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20 * x1 + 15 * x2 <= 450, name="budget_constraint")
    model.addConstr(25 * x1 + 10 * x2 >= 250, name="customer_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Units of Piano A: {x1.varValue}")
        print(f"Units of Piano B: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_piano_problem()
