
import gurobipy as gp

# Create a new model
m = gp.Model("sandwich_optimization")

# Create variables
subs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="subs")
flatbreads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="flatbreads")

# Set objective function
m.setObjective(3 * subs + 2.5 * flatbreads, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * subs + 4 * flatbreads <= 2000, "prep_time")
m.addConstr(2 * subs + 1 * flatbreads <= 2200, "toast_time")
m.addConstr(subs >= 0, "subs_nonnegative")
m.addConstr(flatbreads >= 0, "flatbreads_nonnegative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Subs: {subs.x}")
    print(f"Number of Flatbreads: {flatbreads.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

