
from gurobipy import *

# Create a new model
m = Model("Sandwich_Store")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="subs")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="flatbreads")

# Set the objective function
m.setObjective(3*x1 + 2.50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 4*x2 <= 2000, "preparation_time")
m.addConstr(2*x1 + x2 <= 2200, "toasting_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of subs: {x1.x}")
    print(f"Number of flatbreads: {x2.x}")
    print(f"Maximum profit: ${3*x1.x + 2.50*x2.x:.2f}")
else:
    print("No optimal solution found")
