
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="subs")
    x2 = model.addVar(lb=0, name="flatbreads")

    # Set the objective function
    model.setObjective(3*x1 + 2.5*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x1 + 4*x2 <= 2000, name="preparation_time")
    model.addConstr(2*x1 + x2 <= 2200, name="toasting_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: subs = {x1.varValue}, flatbreads = {x2.varValue}")
        print(f"Maximum profit: ${3*x1.varValue + 2.5*x2.varValue:.2f}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
