
import gurobipy as gp

# Create a new model
m = gp.Model("salad_optimization")

# Create variables
large_salads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="large_salads")  # Number of large salads
small_salads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="small_salads")  # Number of small salads


# Set objective function: Maximize profit
m.setObjective(4 * large_salads + 2 * small_salads, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(45 * large_salads + 30 * small_salads <= 1500, "lettuce_constraint")  # Lettuce constraint
m.addConstr(10 * large_salads + 7 * small_salads <= 1200, "sauce_constraint")  # Sauce constraint
m.addConstr(large_salads >= 0, "non_negativity_large")
m.addConstr(small_salads >= 0, "non_negativity_small")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of large salads: {large_salads.x}")
    print(f"Number of small salads: {small_salads.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

