
from gurobipy import *

# Create a new model
m = Model("Salad_Shop_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="large_salads")
x2 = m.addVar(lb=0, name="small_salads")

# Set the objective function
m.setObjective(4*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(45*x1 + 30*x2 <= 1500, "lettuce_constraint")
m.addConstr(10*x1 + 7*x2 <= 1200, "sauce_constraint")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
