
import gurobi

def solve_salad_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="large_salads", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="small_salads", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Set objective function
    model.setObjective(4 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(45 * x1 + 30 * x2 <= 1500, name="lettuce_constraint")
    model.addConstr(10 * x1 + 7 * x2 <= 1200, name="sauce_constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of large salads: {x1.varValue}")
        print(f"Optimal number of small salads: {x2.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_salad_shop_problem()
