
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tea_shop")

# Create variables
green_tea = m.addVar(vtype=GRB.INTEGER, name="green_tea")  # x1
black_tea = m.addVar(vtype=GRB.INTEGER, name="black_tea")  # x2

# Set objective function
m.setObjective(2 * green_tea + 3 * black_tea, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * green_tea + 5 * black_tea <= 560, "time_constraint")
m.addConstr(green_tea + black_tea <= 150, "total_cups_constraint")
m.addConstr(green_tea >= 0, "green_tea_nonnegative")
m.addConstr(black_tea >= 0, "black_tea_nonnegative")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Green Tea: {green_tea.x}")
    print(f"Black Tea: {black_tea.x}")
    print(f"Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

