
from gurobipy import *

# Create a model
m = Model("Tea_Shop_Optimization")

# Define variables
x1 = m.addVar(name="green_tea", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="black_tea", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 560, name="time_constraint")
m.addConstr(x1 + x2 <= 150, name="product_availability")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of cups of green tea: {x1.x}")
    print(f"Number of cups of black tea: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
