
import gurobipy as gp

# Create a new model
m = gp.Model("TeaShop")

# Define variables
x1 = m.addVar(name="green_tea", lb=0, vtype=gp.GRB.INTEGER)  # cups of green tea
x2 = m.addVar(name="black_tea", lb=0, vtype=gp.GRB.INTEGER)  # cups of black tea

# Objective function: Maximize profit
m.setObjective(2 * x1 + 3 * x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(3 * x1 + 5 * x2 <= 560, name="time_constraint")  # time constraint
m.addConstr(x1 + x2 <= 150, name="product_constraint")  # product constraint

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Green Tea = {x1.varValue}, Black Tea = {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
