
import gurobipy as gp

# Create a new model
m = gp.Model("East Oak Designs")

# Create variables
sofas = m.addVar(vtype=gp.GRB.CONTINUOUS, name="sofas")
cabinets = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cabinets")


# Set objective function
m.setObjective(400 * sofas + 1200 * cabinets, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * sofas + 10 * cabinets <= 100, "lacquer_constraint")
m.addConstr(10 * sofas + 24 * cabinets <= 300, "oak_constraint")
m.addConstr(sofas >=0)
m.addConstr(cabinets >=0)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Sofas: {sofas.x}")
    print(f"  Cabinets: {cabinets.x}")
    print(f"  Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

