
from gurobipy import *

# Create a new model
m = Model("East_Oak_Designs")

# Define the variables
x1 = m.addVar(name="sofas", lb=0)
x2 = m.addVar(name="kitchen_cabinets", lb=0)

# Set the objective function
m.setObjective(400*x1 + 1200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 10*x2 <= 100, name="lacquer_constraint")
m.addConstr(10*x1 + 24*x2 <= 300, name="oak_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sofas to produce: {x1.x}")
    print(f"Kitchen cabinets to produce: {x2.x}")
    print(f"Maximum profit: ${400*x1.x + 1200*x2.x}")
else:
    print("No optimal solution found.")
