
import gurobi

def east_oak_designs_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="sofas", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="kitchen cabinets", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(400 * x1 + 1200 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3 * x1 + 10 * x2 <= 100, name="lacquer_constraint")
    model.addConstr(10 * x1 + 24 * x2 <= 300, name="oak_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal production plan:")
        print(f"Sofas: {x1.varValue}")
        print(f"Kitchen cabinets: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

east_oak_designs_optimization()
