
import gurobipy as gp

# Create a new model
model = gp.Model("PlushToyProduction")

# Create decision variables
small_plush = model.addVar(vtype=gp.GRB.CONTINUOUS, name="small_plush")  # Number of small plush toys
large_plush = model.addVar(vtype=gp.GRB.CONTINUOUS, name="large_plush")  # Number of large plush toys


# Set objective function: Maximize profit
model.setObjective(3 * small_plush + 5 * large_plush, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * small_plush + 8 * large_plush <= 250, "cotton_constraint")  # Cotton constraint
model.addConstr(10 * small_plush + 12 * large_plush <= 500, "time_constraint") # Worker time constraint
model.addConstr(small_plush >= 0, "small_plush_nonneg")  # Non-negativity constraint
model.addConstr(large_plush >= 0, "large_plush_nonneg")  # Non-negativity constraint


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small plush toys: {small_plush.x}")
    print(f"Number of large plush toys: {large_plush.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

