
from gurobipy import *

# Create a new model
m = Model("plush_toys")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="small_plush", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="large_plush", lb=0)

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 8*x2 <= 250, "cotton_limit")
m.addConstr(10*x1 + 12*x2 <= 500, "time_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of small plush toys: {x1.x}")
    print(f"Number of large plush toys: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
