
import gurobipy as gp

# Create a new model
m = gp.Model("Plush_Toys_Optimization")

# Define variables
x1 = m.addVar(name="small_plush_toys", lb=0, vtype=gp.GRB.INTEGER)  # Number of small plush toys
x2 = m.addVar(name="large_plush_toys", lb=0, vtype=gp.GRB.INTEGER)  # Number of large plush toys

# Objective function: Maximize profit
m.setObjective(3*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(5*x1 + 8*x2 <= 250, name="cotton_constraint")  # Cotton constraint
m.addConstr(10*x1 + 12*x2 <= 500, name="worker_time_constraint")  # Worker time constraint

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Produce {x1.varValue} small plush toys and {x2.varValue} large plush toys.")
    print(f"Maximum profit: ${3*x1.varValue + 5*x2.varValue}")
else:
    print("No optimal solution found.")
