
import gurobipy as gp

# Create a new model
m = gp.Model("investment_problem")

# Create variables
wood_investment = m.addVar(name="wood_investment")
bamboo_investment = m.addVar(name="bamboo_investment")

# Set objective function
m.setObjective(0.07 * wood_investment + 0.03 * bamboo_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(wood_investment + bamboo_investment <= 10000, "total_investment")
m.addConstr(wood_investment >= 4 * bamboo_investment, "wood_bamboo_ratio")
m.addConstr(wood_investment <= 7000, "wood_investment_limit")
m.addConstr(wood_investment >= 0, "wood_non_negative")  # Explicit non-negativity constraint
m.addConstr(bamboo_investment >= 0, "bamboo_non_negative") # Explicit non-negativity constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in wood industry: {wood_investment.x}")
    print(f"Optimal investment in bamboo industry: {bamboo_investment.x}")
    print(f"Maximum average return: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

