
from gurobipy import *

# Create a model
m = Model("Marty_Investment")

# Define variables
x1 = m.addVar(lb=0, name="wood_investment")
x2 = m.addVar(lb=0, name="bamboo_investment")

# Set the objective function
m.setObjective(0.07*x1 + 0.03*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 10000, "total_investment")
m.addConstr(x1 >= 4*x2, "wood_vs_bamboo")
m.addConstr(x1 <= 7000, "max_wood_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Wood investment: {x1.x}")
    print(f"Bamboo investment: {x2.x}")
else:
    print("No optimal solution found")
