
import gurobipy as gp

# Create a new model
model = gp.Model("Investment_Problem")

# Define the variables
x1 = model.addVar(name="wood_investment", lb=0)
x2 = model.addVar(name="bamboo_investment", lb=0)

# Objective function: maximize 0.07*x1 + 0.03*x2
model.setObjective(0.07*x1 + 0.03*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 10000, name="total_investment")
model.addConstr(x1 >= 4*x2, name="wood_bamboo_ratio")
model.addConstr(x1 <= 7000, name="wood_investment_limit")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in wood industry: ${x1.varValue:.2f}")
    print(f"Optimal investment in bamboo industry: ${x2.varValue:.2f}")
    print(f"Optimal return: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
