
import gurobipy as gp

# Create a new model
m = gp.Model("burrito_optimization")

# Create variables
beans = m.addVar(lb=0, name="beans")  # Units of beans
onions = m.addVar(lb=0, name="onions") # Units of onions

# Set objective function: Minimize cost
m.setObjective(6 * beans + 8 * onions, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * beans + 2 * onions >= 110, "spice_constraint") # Spice requirement
m.addConstr(3 * beans + 6 * onions >= 80, "flavor_constraint") # Flavor requirement


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal}")
    print(f"Units of beans: {beans.x}")
    print(f"Units of onions: {onions.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

