
from gurobipy import *

# Create a new model
m = Model("Burrito_Optimization")

# Define the variables
x1 = m.addVar(name="beans", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="onions", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(6*x1 + 8*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 2*x2 >= 110, name="spice_constraint")
m.addConstr(3*x1 + 6*x2 >= 80, name="flavor_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Beans: {x1.x}")
    print(f"Onions: {x2.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
