
import gurobi

def solve_burrito_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    x1 = m.addVar(name="beans", lb=0)  # Units of beans
    x2 = m.addVar(name="onions", lb=0)  # Units of onions

    # Objective function: Minimize cost
    m.setObjective(6 * x1 + 8 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    m.addConstr(10 * x1 + 2 * x2 >= 110, name="spice_constraint")
    m.addConstr(3 * x1 + 6 * x2 >= 80, name="flavor_constraint")

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Optimal cost: ", m.objVal)
        print("Units of beans: ", x1.varValue)
        print("Units of onions: ", x2.varValue)
    else:
        print("The problem is infeasible")

solve_burrito_problem()
