
from gurobipy import *

# Create a new model
m = Model("Cat_Food_Optimization")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="packets_of_cat_food")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cans_of_tuna")

# Set the objective function
m.setObjective(12*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 7*x2 >= 700, "carbohydrates_constraint")
m.addConstr(15*x1 + 12*x2 >= 1100, "vitamins_constraint")
m.addConstr(12*x1 + 15*x2 >= 900, "protein_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Packets of cat food: {x1.x}")
    print(f"Cans of tuna: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
