
import gurobi

def solve_cat_food_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="cat_food", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="tuna", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(12 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * x1 + 7 * x2 >= 700, name="carbohydrates")
    model.addConstr(15 * x1 + 12 * x2 >= 1100, name="vitamins")
    model.addConstr(12 * x1 + 15 * x2 >= 900, name="protein")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Packets of cat food: {x1.varValue}")
        print(f"Cans of tuna: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_cat_food_problem()
