
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("MotherboardProduction")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="x1") # 1st generation motherboards
x2 = m.addVar(vtype=GRB.INTEGER, name="x2") # 2nd generation motherboards


# Set objective function
m.setObjective(100*x1 + 125*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 6*x2 <= 450, "Silicon")
m.addConstr(20*x1 + 30*x2 <= 900, "Assembly")
m.addConstr(30*x1 + 40*x2 <= 500, "Soldering")
m.addConstr(x1 >= 6, "Min_x1")
m.addConstr(x2 >= 7, "Min_x2")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"1st generation motherboards: {x1.x}")
    print(f"2nd generation motherboards: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

