
from gurobipy import *

# Create a model
m = Model("Motherboard_Production")

# Add variables
x1 = m.addVar(lb=6, vtype=GRB.INTEGER, name="x1")
x2 = m.addVar(lb=7, vtype=GRB.INTEGER, name="x2")

# Set the objective function
m.setObjective(100*x1 + 125*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 6*x2 <= 450, "silicon")
m.addConstr(20*x1 + 30*x2 <= 900, "assembly")
m.addConstr(30*x1 + 40*x2 <= 500, "soldering")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
