
import gurobi

def solve_motherboard_production():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, vtype=gurobi.GRB.INTEGER)  # 1st generation motherboards
    x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.INTEGER)  # 2nd generation motherboards

    # Set the objective function
    model.setObjective(100 * x1 + 125 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * x1 + 6 * x2 <= 450)  # Silicon constraint
    model.addConstr(20 * x1 + 30 * x2 <= 900)  # Assembly time constraint
    model.addConstr(30 * x1 + 40 * x2 <= 500)  # Soldering time constraint
    model.addConstr(x1 >= 6)  # Minimum 1st generation motherboards
    model.addConstr(x2 >= 7)  # Minimum 2nd generation motherboards

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_motherboard_production()
