
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Toms_Florist")

# Create variables
sunflowers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sunflowers")  # Number of sunflower bouquets
roses = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="roses")  # Number of rose bouquets

# Set objective function: Maximize profit
m.setObjective(7 * sunflowers + 12 * roses, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * sunflowers + 5 * roses <= 1200, "clipping_time")  # Clipping time constraint
m.addConstr(3 * sunflowers + 7 * roses <= 800, "packaging_time")  # Packaging time constraint
m.addConstr(sunflowers >= 30, "sunflower_contract")  # Minimum sunflower bouquets constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of sunflower bouquets: {sunflowers.x:.2f}")
    print(f"Number of rose bouquets: {roses.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

