
from gurobipy import *

# Create a new model
m = Model("Tom's Florist")

# Define variables
x1 = m.addVar(lb=30, name="sunflowers")  # Number of bouquets of sunflowers, lower bound is 30 due to contract
x2 = m.addVar(name="roses")  # Number of bouquets of roses

# Set the objective function: maximize profit
m.setObjective(7*x1 + 12*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 5*x2 <= 1200, name="clipping_time")
m.addConstr(3*x1 + 7*x2 <= 800, name="packaging_time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sunflowers: {x1.x}")
    print(f"Roses: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
