
import gurobipy as gp

def solve_florist_problem():
    # Create a new model
    model = gp.Model("Tom's Florist")

    # Define variables
    x1 = model.addVar(name="sunflowers", lb=30, vtype=gp.GRB.CONTINUOUS)  # At least 30 bouquets of sunflowers
    x2 = model.addVar(name="roses", vtype=gp.GRB.CONTINUOUS)  # No limit on bouquets of roses

    # Objective function: Maximize profit
    model.setObjective(7 * x1 + 12 * x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * x1 + 5 * x2 <= 1200, name="clipping_time")
    model.addConstr(3 * x1 + 7 * x2 <= 800, name="packaging_time")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found. Profit: ${model.objVal:.2f}")
        print(f"Bouquets of sunflowers: {x1.varValue:.2f}")
        print(f"Bouquets of roses: {x2.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_florist_problem()
