
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("train_profit")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="first_class_seats")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(1200*x1 + 700*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300, "total_seats")
m.addConstr(x1 >= 50, "min_first_class")
m.addConstr(x2 >= 3*x1, "regular_preference")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of first-class seats: {x1.x}")
    print(f"Number of regular seats: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

