
from gurobipy import *

# Create a new model
m = Model("Train_Seat_Optimization")

# Define variables
x1 = m.addVar(name='first_class_seats', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='regular_seats', vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(1200*x1 + 700*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 300, name='total_seats')
m.addConstr(x1 >= 50, name='min_first_class')
m.addConstr(x2 >= 3*x1, name='regular_vs_first_class')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Number of first-class seats: {x1.x}")
    print(f"Number of regular seats: {x2.x}")
    print(f"Maximum profit: ${1200*x1.x + 700*x2.x}")
else:
    print("No optimal solution found.")

