
import gurobi

def solve_train_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="first_class_seats", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="regular_seats", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize profit
    model.setObjective(1200 * x1 + 700 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 300, name="total_seats")
    model.addConstr(x1 >= 50, name="min_first_class")
    model.addConstr(x2 >= 3 * x1, name="regular_preference")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: First-class seats = {x1.varValue}, Regular seats = {x2.varValue}")
        print(f"Maximum profit: ${1200 * x1.varValue + 700 * x2.varValue}")
    else:
        print("The model is infeasible.")

solve_train_seating_problem()
