
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("hardware_manufacturing")

# Create variables
cpus = m.addVar(vtype=GRB.INTEGER, name="cpus")
gpus = m.addVar(vtype=GRB.INTEGER, name="gpus")

# Set objective function
m.setObjective(300 * cpus + 500 * gpus, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * cpus + 90 * gpus <= 2000, "wiring_constraint")
m.addConstr(50 * cpus + 40 * gpus <= 2500, "soldering_constraint")
m.addConstr(cpus >= 0, "cpus_nonnegative")
m.addConstr(gpus >= 0, "gpus_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of CPUs to manufacture: {cpus.x}")
    print(f"Number of GPUs to manufacture: {gpus.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

