
from gurobipy import *

# Create a new model
m = Model("CPU_GPU_Production")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="CPUs")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="GPUs")

# Set the objective function
m.setObjective(300*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 90*x2 <= 2000, "Wiring_Time")
m.addConstr(50*x1 + 40*x2 <= 2500, "Soldering_Time")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x1.x} CPUs and {x2.x} GPUs")
else:
    print("No optimal solution found")
