
import gurobipy as gp

# Create a new model
model = gp.Model("CPU_GPU_Production")

# Define variables
x1 = model.addVar(name="CPUs", lb=0, vtype=gp.GRB.INTEGER)  # Number of CPUs
x2 = model.addVar(name="GPUs", lb=0, vtype=gp.GRB.INTEGER)  # Number of GPUs

# Objective function: Maximize profit
model.setObjective(300*x1 + 500*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(30*x1 + 90*x2 <= 2000, name="Wiring_Time")  # Wiring time constraint
model.addConstr(50*x1 + 40*x2 <= 2500, name="Soldering_Time")  # Soldering time constraint

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: CPUs = {x1.varValue}, GPUs = {x2.varValue}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
