
import gurobipy as gp

# Create a new model
m = gp.Model("sign_optimization")

# Create variables
neon_signs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="neon_signs")
metal_signs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="metal_signs")


# Set objective function
m.setObjective(200 * neon_signs + 100 * metal_signs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * neon_signs + 2 * metal_signs <= 950, "crafting_constraint")
m.addConstr(2 * neon_signs + 1.5 * metal_signs <= 400, "installation_constraint")
m.addConstr(neon_signs >= 0, "neon_signs_nonnegative")
m.addConstr(metal_signs >= 0, "metal_signs_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of neon signs: {neon_signs.x}")
    print(f"Number of metal signs: {metal_signs.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

