
from gurobipy import *

# Create a new model
m = Model("Sign_Crafting")

# Define variables
x1 = m.addVar(name="neon_signs", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="metal_signs", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(200*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 <= 950, name="crafting_hours")
m.addConstr(2*x1 + 1.5*x2 <= 400, name="installation_hours")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of neon signs: {x1.x}")
    print(f"Number of metal signs: {x2.x}")
    print(f"Maximum profit: ${200*x1.x + 100*x2.x:.2f}")
else:
    print("No optimal solution found")
