
import gurobipy as gp

# Create a new model
model = gp.Model("Sign_Company_Optimization")

# Define variables
x1 = model.addVar(name="neon_signs", lb=0, vtype=gp.GRB.INTEGER)  # Number of neon signs
x2 = model.addVar(name="metal_signs", lb=0, vtype=gp.GRB.INTEGER)  # Number of metal signs

# Objective function: Maximize profit
model.setObjective(200 * x1 + 100 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3 * x1 + 2 * x2 <= 950, name="crafting_time_constraint")
model.addConstr(2 * x1 + 1.5 * x2 <= 400, name="installation_time_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Max Profit: ${200 * x1.x + 100 * x2.x}")
else:
    print("No optimal solution found.")
