
import gurobipy as gp

# Create a new model
model = gp.Model("Calculator Production")

# Create decision variables
scientific = model.addVar(lb=0, name="scientific")  # Number of scientific calculators
graphing = model.addVar(lb=0, name="graphing")  # Number of graphing calculators


# Set objective function: Maximize profit
model.setObjective(6 * scientific + 8 * graphing, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * scientific + 4 * graphing <= 100, "silicon")  # Silicon constraint
model.addConstr(4 * scientific + 6 * graphing <= 200, "plastic")  # Plastic constraint
model.addConstr(1 * scientific + 2 * graphing <= 50, "silver")  # Silver constraint

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Scientific Calculators: {scientific.x}")
    print(f"  Graphing Calculators: {graphing.x}")
    print(f"  Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

