
import gurobipy as gp

# Create a new model
model = gp.Model("Calculator_Production")

# Define variables
x1 = model.addVar(name="scientific_calculators", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="graphing_calculators", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: maximize profit
model.setObjective(6*x1 + 8*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2*x1 + 4*x2 <= 100, name="silicon_constraint")
model.addConstr(4*x1 + 6*x2 <= 200, name="plastic_constraint")
model.addConstr(x1 + 2*x2 <= 50, name="silver_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Scientific Calculators: {x1.varValue}")
    print(f"Graphing Calculators: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or has no solution.")
